#define MAX 20
#define FALSE -1
#define TRUE   0

#define VACIO   0
#define OCUPADO   1
#define INEXISTENTE   -1

#include <dos.h>
#include <alloc.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>

		typedef int Turno[4]; //carnet de los estudiantes que tienen turno en
													//cada una de las salas.
													//0  micro libre, -1  micro inexistente.
		struct Estud
		{  int carnet;        //carnet del estudiante.
			 struct Estud *sig; //siguiente estudiante en la lista.
		};

		struct Curso
		{  int codigo;        //cdigo del curso.
			 struct Estud *est; //lista de estudiantes en el curso.
			 struct Curso  *sig; //siguiente curso en la lista.
		};

		typedef struct
		{  Turno turnos[12][MAX];  //matriz de turnos.
			 struct Curso *sala1;    //lista de cursos asignados a la sala 1.
			 struct Curso *sala2;    //lista de cursos asignados a la sala 2.
			 struct Curso *sala3;    //lista de cursos asignados a la sala 3.
			 struct Curso *sala4;    //lista de cursos asignados a la sala 4.
		} *Salas;
//****************************************************************************
//								   MONITOREO-DEL-PASO-AL-MODO-GRAFICO
//****************************************************************************
void ver_errores()
{ int i,error;
	error = graphresult();
	if (error != grOk)
	{
		clrscr();
		gotoxy(1,8);
		printf("%69s","۲\n");
		printf("%69s","Ŀ۲\n");
		printf("%69s","۳ ADMINISTRADOR DE LABORATORIOS ۲\n");
		printf("%69s","۳                               ۲\n");
		printf("%69s","۳         Version 1.29          ۲\n");
		printf("%69s","۲\n");
		printf("%69s","۲\n");
		gotoxy(1,20);
		printf("%61s\n","Error al tratar de pasar al modo grfico.");
		printf("%66s","Presione cualquier tecla para detener la ejecucin.");
		getch();
		exit(1);
	}
}
//****************************************************************************
//																MENSAJES
//****************************************************************************
void msgbox(char titulo[],char msg[])
{
	clearviewport();
	setusercharsize(1,2,1,2);
	settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
	setfillstyle(4,2);  	// sombra.
	bar(125,120,515,205);	// sombra.
	setfillstyle(4,2);    // titulo.
	bar(121,116,509,140); // titulo.
	setfillstyle(4,0);    // mensaje.
	bar(121,140,509,200); // mensaje.
	rectangle(120,115,510,200);
	line(120,140,510,140);
	outtextxy((640-(strlen(titulo)*textwidth("T")))/2,117,titulo);
	outtextxy((640-(strlen(msg)*textwidth("T")))/2+20,155,msg);
	getch();
	clearviewport();
}
//****************************************************************************
// 														LECTURA-DE-DATOS
//****************************************************************************
int mpscanf(char texto[])
{
	int sw,i,Done,ch,numero;
	char string[20],num[20];
	setusercharsize(1,2,1,2);
	i = 0;
	sw=FALSE;
	Done=FALSE;
	while (Done==FALSE) {
		string[i]=getch();
		ch=string[i];
		i++;
		switch (ch) {
			case 13:  {
			if(sw==FALSE){
			msgbox("Error de Lectura","Debe colocar un dato vlido");
			outtext(texto);
			Done = FALSE;
			}
			else Done=TRUE;
			break; }										//{ Enter }
			case 48:  { sw=TRUE;outtext("0");	break; }
			case 49:  { sw=TRUE;outtext("1");	break; }
			case 50:  { sw=TRUE;outtext("2");	break; }
			case 51:  { sw=TRUE;outtext("3");	break; }
			case 52:  { sw=TRUE;outtext("4");	break; }
			case 53:  { sw=TRUE;outtext("5");	break; }
			case 54:  { sw=TRUE;outtext("6");	break; }
			case 55:  { sw=TRUE;outtext("7");	break; }
			case 56:  { sw=TRUE;outtext("8");	break; }
			case 57:  { sw=TRUE;outtext("9");	break; }
			default:  { for(i=20;i>=0;i--){string[i]=NULL;};
									clearviewport();
									outtext(texto);
									i=0;
									break; }
		}  // switch externo.
	}    // while.
	string[i] = NULL;
	numero = atoi(string);
	return numero;
}
//*****************************************************************************
//												DIBUJA-EL-MENU-PRINCIPAL
//****************************************************************************
void menu_principal()
{
	 cleardevice();
	 setviewport(0,0,getmaxx(),getmaxy(),1);
	 setfillstyle(4,2);
	 bar(8,8,630,50);
	 rectangle(8,8,630,50);
	 setusercharsize(8,9,8,9);
	 settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
	 outtextxy((640-(strlen("ADMINISTRADOR DE LABORATORIOS")*textwidth("T")))/2,10,"ADMINISTRADOR DE LABORATORIOS");

	 setusercharsize(1,2,1,2);

	 outtextxy(10,50, "Base de Datos");
	 line(10,68,17,68);
	 outtextxy(180,50, "Estructura");
	 line(180,68,187,68);
	 outtextxy(340,50, "Ayuda");
	 line(340,68,347,68);
	 outtextxy(460,50, "Creditos");
	 line(460,68,467,68);
	 outtextxy(600,50, "Salir");
	 line(600,68,607,68);
}
//*****************************************************************************
//											 CREA-LA-ESTRUCTURA-DE-DATOS
//****************************************************************************
Salas crear()
{
	int i,j,k;
	Salas planilla;

	for (i=0; i<12; i++)
		for (j=0;j<MAX;j++)
			for (k=0; k<4; k++)
				planilla->turnos[i][j][k] = 0;

	planilla->sala1 = /*NULL;*/(Curso *)malloc(sizeof(Curso));
	planilla->sala1->sig =  NULL;

	planilla->sala2 = /*NULL;*/(Curso *)malloc(sizeof(Curso));
	planilla->sala2->est =  (Estud *)malloc(sizeof(Estud));

	planilla->sala3 = /*NULL;*/(Curso *)malloc(sizeof(Curso));
	planilla->sala3->est =  (Estud *)malloc(sizeof(Estud));

	planilla->sala4 = /*NULL;*/(Curso *)malloc(sizeof(Curso));
	planilla->sala4->est =  (Estud *)malloc(sizeof(Estud));

	return planilla;
}
//*****************************************************************************
//  									NUMERO-DE-MICROS-DE-CADA-SALA
//*****************************************************************************
int s1,s2,s3,s4;
//*****************************************************************************
//										 INICIALIZACION-DE-LA-MATRIZ
//*****************************************************************************
Salas init_salas(Salas planilla){
int i,j;
clearviewport();
setfillstyle(4,2);
bar(8,8,630,50);
rectangle(8,8,630,50);
setusercharsize(8,9,8,9);
settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
outtextxy(190,10, "INICIALIZAR PLANILLA");
setviewport(8,80,getmaxx(),getmaxy(),1); 	// area lgica del video.
msgbox("Informacin","Es necesario que proporcione algunos datos.");
setusercharsize(1,2,1,2);

outtextxy(0,0,"Nmero de micros de la sala 1: ");
moveto(28*textwidth("T"),0);
s1 = mpscanf("Nmero de micros de la sala 1: ");

while (s1>MAX){
	msgbox("Error","El mximo es 20.   ");
	outtextxy(0,0,"Nmero de micros de la sala 1: ");
	moveto(28*textwidth("T"),0);
	s1 = mpscanf("Nmero de micros de la sala 1: ");
}

for (i=0;i<12;i++){
for (j=0;j<MAX;j++){
	if(j<=s1){
		planilla->turnos[i][j][1] = VACIO;
	}
	else planilla->turnos[i][j][1] = INEXISTENTE;
}
}

clearviewport();
outtextxy(0,0,"Nmero de micros de la sala 2: ");
moveto(28*textwidth("T"),0);
s2 = mpscanf("Nmero de micros de la sala 2: ");

while (s2>MAX){
	msgbox("Error","El mximo es 20.   ");
	outtextxy(0,0,"Nmero de micros de la sala 2: ");
	moveto(28*textwidth("T"),0);
	s2 = mpscanf("Nmero de micros de la sala 2: ");
}

for (i=0;i<12;i++){
for (j=0;j<MAX;j++){
	if(j<=s2){
		planilla->turnos[i][j][1] = VACIO;
	}
	else planilla->turnos[i][j][1] = INEXISTENTE;
}
}

clearviewport();
outtextxy(0,0,"Nmero de micros de la sala 3: ");
moveto(28*textwidth("T"),0);
s3 = mpscanf("Nmero de micros de la sala 3: ");

while (s3>MAX){
	msgbox("Error","El mximo es 20.   ");
	outtextxy(0,0,"Nmero de micros de la sala 3: ");
	moveto(28*textwidth("T"),0);
	s3 = mpscanf("Nmero de micros de la sala 3: ");
}

for (i=0;i<12;i++){
for (j=0;j<MAX;j++){
	if(j<=s3){
		planilla->turnos[i][j][1] = VACIO;
	}
	else planilla->turnos[i][j][1] = INEXISTENTE;
}
}

clearviewport();
outtextxy(0,0,"Nmero de micros de la sala 4: ");
moveto(28*textwidth("T"),0);
s4 = mpscanf("Nmero de micros de la sala 4: ");

while (s4>MAX){
	msgbox("Error","El mximo es 20.   ");
	outtextxy(0,0,"Nmero de micros de la sala 4: ");
	moveto(28*textwidth("T"),0);
	s4 = mpscanf("Nmero de micros de la sala 4: ");
}

for (i=0;i<12;i++){
for (j=0;j<MAX;j++){
	if(j<=s4){
		planilla->turnos[i][j][1] = VACIO;
	}
	else planilla->turnos[i][j][1] = INEXISTENTE;
}
}
 return planilla;
}
//****************************************************************************
//							           AGREGA-UN-NUEVO-CURSO
//****************************************************************************
Salas agregar_curso(int sal, int cod, Salas planilla)
{
	Curso *aux;
		switch (sal) {
			case 1:    {   if (planilla->sala1 == NULL){	planilla->sala1 = (Curso *)malloc(sizeof(Curso));
																						planilla->sala1->sig = NULL;
																						planilla->sala1->codigo = cod;
																					}
										 else {
											aux = (Curso *)malloc(sizeof(Curso));
											aux->codigo = cod;
											aux->sig = planilla->sala1;
											aux->est=(Estud *)malloc(sizeof(Estud));
											aux->est->sig=NULL;
											planilla->sala1 = aux;
											msgbox("Informacin","El curso especificado ha sido agregado.  ");
													}
										 break;
								 }
			case 2:    {   if (planilla->sala2 == NULL){	planilla->sala2 = (Curso *)malloc(sizeof(Curso));
																						planilla->sala2->sig = NULL;
																						planilla->sala2->codigo = cod;
																					}
										 else {
											aux = (Curso *)malloc(sizeof(Curso));
											aux->codigo = cod;
											aux->sig = planilla->sala2;
											aux->est=(Estud *)malloc(sizeof(Estud));
											aux->est->sig=NULL;
											planilla->sala2 = aux;
											msgbox("Informacin","El curso especificado ha sido agregado.  ");
										 }
										 break;
									}
			case 3:    {   if (planilla->sala3 == NULL){	planilla->sala3 = (Curso *)malloc(sizeof(Curso));
																						planilla->sala3->sig = NULL;
																						planilla->sala3->codigo = cod;
																					}
										 else {
											aux = (Curso *)malloc(sizeof(Curso));
											aux->codigo = cod;
											aux->sig = planilla->sala3;
											aux->est=(Estud *)malloc(sizeof(Estud));
											aux->est->sig=NULL;
											planilla->sala3 = aux;
											msgbox("Informacin","El curso especificado ha sido agregado.  ");
													}
										 break;
								 }
			case 4:    {   if (planilla->sala4 == NULL){	planilla->sala4 = (Curso *)malloc(sizeof(Curso));
																						planilla->sala4->sig = NULL;
																						planilla->sala4->codigo = cod;
																					 }
										 else {
											aux = (Curso *)malloc(sizeof(Curso));
											aux->codigo = cod;
											aux->sig = planilla->sala4;
											aux->est=(Estud *)malloc(sizeof(Estud));
											aux->est->sig=NULL;
											planilla->sala4 = aux;
											msgbox("Informacin","El curso especificado ha sido agregado.  ");
										 }
										 break;
									}
			} // switch externo.
	return (planilla);
}
//******************************************************************************
//											  		BUSCA-UN-CURSO
//****************************************************************************
int buscar_curso(int sal,int cod,Salas planilla)
{
int i,temp;
Curso *aux;
temp = FALSE;
switch (sal){
	case 1: {
					 aux = planilla->sala1;
					 while(aux->sig != NULL)
					 {
						if (aux->codigo==cod) {
								temp = TRUE;
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
					 break;
					}
	case 2: {
					 aux = planilla->sala2;
					 while(aux->sig != NULL)
					 {
						if (aux->codigo==cod) {
								temp = TRUE;
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
					 break;
					}
	case 3: {
					 aux = planilla->sala3;
					 while(aux->sig != NULL)
					 {
						if (aux->codigo==cod) {
								temp = TRUE;
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
					 break;
					}
	case 4: {
					 aux = planilla->sala4;
					 while(aux->sig != NULL)
					 {
						if (aux->codigo==cod) {
								temp = TRUE;
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
					 break;
					}
}// switch
return temp;
}
//******************************************************************************
//											AGREGA-UN-ESTUDIANTE
//****************************************************************************
void agregar_estudiante(int sal,int cod, int carn, Salas planilla)
{
	int temp;
	Curso *aux;
	Estud *aux1;
	char opcion;
	temp = buscar_curso(sal,cod,planilla);
	if(temp==FALSE) msgbox("Error","El curso especificado no existe.   ");
	else{
		switch(sal){
		case 1:{
			aux=planilla->sala1;
			while(aux->sig != NULL){
				if (aux->codigo == cod){
				aux1=(Estud *)malloc (sizeof(Estud));
				aux1->carnet=carn;
				aux1->sig=aux->est;
				aux->est=aux1;
				msgbox("Informacin","El Estudiante ha sido agregado.  ");
				break;
			} // if
			else
			{
				aux=aux->sig;
			}
		} // while
		break;
		}//case 1
		case 2:{
				aux=planilla->sala2;
				while(aux->sig != NULL){
					if (aux->codigo == cod){
						aux1=(Estud *)malloc (sizeof(Estud));
						aux1->carnet=carn;
						aux1->sig=aux->est;
						aux->est=aux1;
						msgbox("Informacin","El Estudiante ha sido agregado.  ");
						break;
					} // if
					else
					{
						aux=aux->sig;
					}
				} // while
				break;
		}//case 2
		case 3:{
				aux=planilla->sala3;
				while(aux->sig != NULL){
					if (aux->codigo == cod){
						aux1=(Estud *)malloc (sizeof(Estud));
						aux1->carnet=carn;
						aux1->sig=aux->est;
						aux->est=aux1;
						msgbox("Informacin","El Estudiante ha sido agregado.  ");
						break;
					} // if
					else
					{
						aux=aux->sig;
					}
				} // while
			break;
		}//case 3
		case 4:{
				aux=planilla->sala4;
				while(aux->sig != NULL){
						if (aux->codigo == cod){
							aux1=(Estud *)malloc (sizeof(Estud));
							aux1->carnet=carn;
							aux1->sig=aux->est;
							aux->est=aux1;
							msgbox("Informacin","El Estudiante ha sido agregado.  ");
							break;
						} // if
						else
						{
							aux=aux->sig;
						}
				} // while
				break;
		}//case 4
	}//switch
	}   //else
}
//******************************************************************************
//													BUSCA-UN-ESTUDIANTE
//******************************************************************************
int buscar_estudiante(int sal,int cod,int carn, Salas planilla)	//NF
{
int i,temp;
Curso *aux;
Estud *aux1;
temp = FALSE;
switch (sal){
		case 1: {
					 aux = planilla->sala1;
					 while(aux->sig != NULL)
					 {
						 if (aux->codigo==cod) {
							 aux1=aux->est;
							 while(aux1->sig != NULL)
							 {
								if (aux1->carnet==carn) {
										temp = TRUE;
										break;
								}
								else{
									aux1 = aux1->sig;
								}
								} // while.
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
						break;
					}
		case 2: {
					 aux = planilla->sala2;
					 while(aux->sig != NULL)
					 {
						 if (aux->codigo==cod) {
							 aux1=aux->est;
							 while(aux1->sig != NULL)
							 {
								if (aux1->carnet==carn) {
										temp = TRUE;
										break;
								}
								else{
									aux1 = aux1->sig;
								}
								} // while.
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
						break;
					}
		case 3: {
					 aux = planilla->sala3;
					 while(aux->sig != NULL)
					 {
						 if (aux->codigo==cod) {
							 aux1=aux->est;
							 while(aux1->sig != NULL)
							 {
								if (aux1->carnet==carn) {
										temp = TRUE;
										break;
								}
								else{
									aux1 = aux1->sig;
								}
								} // while.
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
						break;
					}
		case 4: {
					 aux = planilla->sala4;
					 while(aux->sig != NULL)
					 {
						 if (aux->codigo==cod) {
							 aux1=aux->est;
							 while(aux1->sig != NULL)
							 {
								if (aux1->carnet==carn) {
										temp = TRUE;
										break;
								}
								else{
									aux1 = aux1->sig;
								}
								} // while.
								break;
						}
						else{
							aux = aux->sig;
						}
						} // while.
						break;
					}
}// switch
return temp;
}
//******************************************************************************
//											AGREGA-UN-NUEVO-TURNO
//******************************************************************************
void agregar_turno(int sal,int cod,int carn,int hor,Salas planilla)
{
int temp,micro;
char asignado[30],msg[50] = "Micro asignado: ";
temp = buscar_estudiante(sal,cod,carn,planilla);
if(temp==TRUE){
temp = hor;
switch (hor){
	case 7:  { hor = 0; break; }
	case 8:  { hor = 1; break; }
	case 9:  { hor = 2; break; }
	case 10: { hor = 3; break; }
	case 11: { hor = 4; break; }
	case 12: { hor = 5; break; }
	case 1:  { hor = 6; break; }
	case 2:  { hor = 7; break; }
	case 3:  { hor = 8; break; }
	case 4:  { hor = 9; break; }
	case 5:  { hor = 10; break; }
	case 6:  { hor = 11; break; }
}
switch(sal){
case 1:{
				 for(micro=0;micro<s1;micro++){
						if (planilla->turnos[hor][micro][1] == VACIO){
								planilla->turnos[hor][micro][1] = carn;
								itoa(micro,asignado,10);
								strcat(msg,asignado);
								strcat(msg,",sala ");
								itoa(sal,asignado,10);
								strcat(msg,asignado);
								strcat(msg,", hora ");
								itoa(temp,asignado,10);
								strcat(msg,asignado);
								msgbox("Informacin",msg);
								break;
						}
				 }
				 break;
				}		//case
case 2:{
				 for(micro=0;micro<s2;micro++){
						if (planilla->turnos[hor][micro][2] == VACIO){
								planilla->turnos[hor][micro][2] = carn;
								itoa(micro,asignado,10);
								strcat(msg,asignado);
								strcat(msg,",sala ");
								itoa(sal,asignado,10);
								strcat(msg,asignado);
								strcat(msg,", hora ");
								itoa(temp,asignado,10);
								strcat(msg,asignado);
								msgbox("Informacin",msg);
								break;
						}
				 }
				 break;
				}		//case
case 3:{
				 for(micro=0;micro<s2;micro++){
						if (planilla->turnos[hor][micro][3] == VACIO){
								planilla->turnos[hor][micro][3] = carn;
								itoa(micro,asignado,10);
								strcat(msg,asignado);
								strcat(msg,",sala ");
								itoa(sal,asignado,10);
								strcat(msg,asignado);
								strcat(msg,", hora ");
								itoa(temp,asignado,10);
								strcat(msg,asignado);
								msgbox("Informacin",msg);
								break;
						}
				 }
				 break;
				}		//case
case 4:{
				 for(micro=0;micro<s2;micro++){
						if (planilla->turnos[hor][micro][4] == VACIO){
								planilla->turnos[hor][micro][4] = carn;
								itoa(micro,asignado,10);
								strcat(msg,asignado);
								strcat(msg,",sala ");
								itoa(sal,asignado,10);
								strcat(msg,asignado);
								strcat(msg,", hora ");
								itoa(temp,asignado,10);
								strcat(msg,asignado);
								msgbox("Informacin",msg);
								break;
						}
				 }
				 break;
				}		//case
}		 //switch
}		 //if
else msgbox("Error","El Curso o alumno especificado no existe");
}
//****************************************************************************
// 														CONSULTAR-TURNO
//****************************************************************************
void consultar_turno(int sal,int hor,int micro,Salas planilla)
{
char carn[20],msg[50] = "Micro reservado, carnet:  ";
switch (hor){
	case 7:  { hor = 0; break; }
	case 8:  { hor = 1; break; }
	case 9:  { hor = 2; break; }
	case 10: { hor = 3; break; }
	case 11: { hor = 4; break; }
	case 12: { hor = 5; break; }
	case 1:  { hor = 6; break; }
	case 2:  { hor = 7; break; }
	case 3:  { hor = 8; break; }
	case 4:  { hor = 9; break; }
	case 5:  { hor = 10; break; }
	case 6:  { hor = 11; break; }
}
				if (planilla->turnos[hor][micro][sal] == VACIO){
						msgbox("Informacin","Micro Vaco    ");
				}
				else if (planilla->turnos[hor][micro][sal] == INEXISTENTE){
						msgbox("Informacin","Micro Inexistente   ");
				}
				else{
					itoa(planilla->turnos[hor][micro][sal],carn,10);
					strcat(msg,carn);
					msgbox("Informacin",msg);
				}
}
//****************************************************************************
//														 CANCELAR-TURNO
//****************************************************************************
void cancelar_turno(int sal,int hor,int micro,Salas planilla)
{
char option[2];
switch (hor){
	case 7:  { hor = 0; break; }
	case 8:  { hor = 1; break; }
	case 9:  { hor = 2; break; }
	case 10: { hor = 3; break; }
	case 11: { hor = 4; break; }
	case 12: { hor = 5; break; }
	case 1:  { hor = 6; break; }
	case 2:  { hor = 7; break; }
	case 3:  { hor = 8; break; }
	case 4:  { hor = 9; break; }
	case 5:  { hor = 10; break; }
	case 6:  { hor = 11; break; }
}
moveto(0,80);
outtext("<< Est seguro de que desea cancelar el turno referenciado (s/n) ? >>  ");
option[0] = getch();
if (option[0] == 's'){
		if (planilla->turnos[hor][micro][sal] == VACIO){
			msgbox("Error","El micro especificado ya est vaco");
		}
		else if (planilla->turnos[hor][micro][sal] == INEXISTENTE){
			msgbox("Error","El micro especificado no existe");
		}
		else{
			planilla->turnos[hor][micro][sal] = VACIO;
			msgbox("Informacin","El turno dado acaba de ser cancelado");
		}
}
else msgbox("Informacin","El turno referenciado no ha sido cancelado");
}
//*****************************************************************************
// 														MENU-BASE-DE-DATOS
//*****************************************************************************
void base_de_datos(Salas planilla)
{
	int sal,cod,carn,hor,i,opcion,linea,micro,Done,c,idc,sw;
	char ch[3];
	char op[5][50]={"Nuevo turno",
									"Consultar turno",
									"Cancelar turno",
									"Agregar curso",
									"Agregar estudiante"};

	clearviewport();
	rectangle(0,0,180,144);
	setusercharsize(1,2,1,2);
	settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);

	for (i=1;i<5; i++){
			outtextxy(20,(i*20)+20,op[i]);
	}

	setfillstyle(4,2);
	bar(1,20,179,42);
	rectangle(1,20,179,42);
	outtextxy(20,20,op[0]);

	opcion = 1;
	linea = 20;

	Done=FALSE;
	while (Done==FALSE) {
		c=getch();
		switch (c) {
			case 0: {
				c=getch();
				switch (c){
case 80: {                        					// abajo
					setfillstyle(4,0);
					bar(1,linea,179,linea+22);
					outtextxy(20,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 5){
														 linea = 20;
														 opcion = 1;
														 }
					else {
								linea += 20;
								opcion++;
								}
					bar(1,linea,179,linea+22);
					rectangle(1,linea,179,linea+22);
					outtextxy(20,linea,op[opcion-1]);
					break;
					}
case 72: {                        					// arriba
					setfillstyle(4,0);
					bar(1,linea,179,linea+22);
					outtextxy(20,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 1){
														 linea = 100;
														 opcion = 5;
														 }
					else {
								linea -= 20;
								opcion--;
								}
					bar(1,linea,179,linea+22);
					rectangle(1,linea,179,linea+22);
					outtextxy(20,linea,op[opcion-1]);
					break;
					}
				} 				// switch interno.
				break;
			} 					// case externo.
			case 13:  { Done=TRUE;	break; }		    								  //{ Enter }
			case 27:  {	Done=TRUE;	sw = TRUE;	opcion = 0;	break; }  //{	Esc	}
		}  // switch externo.
	}    // while.
	itoa(opcion,ch,i);
	outtext(ch);

	switch (opcion){
		case 1: { 	cleardevice();
								setviewport(0,0,getmaxx(),getmaxy(),1);
								setfillstyle(4,2);
								bar(8,8,630,50);
								rectangle(8,8,630,50);
								setusercharsize(8,9,8,9);
								settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
								outtextxy((640-(strlen("NUEVO TURNO")*textwidth("T")))/2,10,"NUEVO TURNO");
								setusercharsize(1,2,1,2);
								setviewport(8,80,getmaxx(),getmaxy(),1);
								outtextxy(0,0,"Sala: ");
								moveto(8*8,0);
								sal = mpscanf("Sala:  ");
								while (sal<1 || sal>4){
									msgbox("Error","Slo hay cuatro salas");
									outtextxy(0,0,"Sala: ");
									moveto(8*8,0);
									sal = mpscanf("Sala:  ");
								}
								outtextxy(0,20,"Cdigo del curso: ");
								moveto(20*8,20);
								cod = mpscanf("Cdigo del curso: ");
								outtextxy(0,40,"Carnet: ");
								moveto(8*8,40);
								carn = mpscanf("Carnet: ");
								outtextxy(0,60,"Hora: ");
								moveto(8*8,60);
								hor = mpscanf("Hora: ");
								agregar_turno(sal,cod,carn,hor,planilla);
								menu_principal();
								setviewport(8,80,getmaxx(),getmaxy(),1);
								break;
							 }
		case 2: { 	cleardevice();
								setviewport(0,0,getmaxx(),getmaxy(),1);
								setfillstyle(4,2);
								bar(8,8,630,50);
								rectangle(8,8,630,50);
								setusercharsize(8,9,8,9);
								settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
								outtextxy((640-(strlen("CONSULTAR TURNO")*textwidth("T")))/2,10,"CONSULTAR TURNO");
								setusercharsize(1,2,1,2);
								setviewport(8,80,getmaxx(),getmaxy(),1);
								outtextxy(0,0,"Sala: ");
								moveto(8*8,0);
								sal = mpscanf("Sala:  ");
								while (sal<1 || sal>4){
									msgbox("Error","Slo hay cuatro salas");
									outtextxy(0,0,"Sala: ");
									moveto(8*8,0);
									sal = mpscanf("Sala:  ");
								}
								outtextxy(0,20,"Micro: ");
								moveto(8*8,20);
								micro = mpscanf("Micro: ");
								outtextxy(0,40,"Hora: ");
								moveto(8*8,40);
								hor = mpscanf("Hora: ");
								consultar_turno(sal,hor,micro,planilla);
								menu_principal();
								setviewport(8,80,getmaxx(),getmaxy(),1);
								break;
							 }
		case 3: { 	cleardevice();
								setviewport(0,0,getmaxx(),getmaxy(),1);
								setfillstyle(4,2);
								bar(8,8,630,50);
								rectangle(8,8,630,50);
								setusercharsize(8,9,8,9);
								settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
								outtextxy((640-(strlen("CANCELAR TURNO")*textwidth("T")))/2,10,"CANCELAR TURNO");
								setusercharsize(1,2,1,2);
								setviewport(8,80,getmaxx(),getmaxy(),1);
								outtextxy(0,0,"Sala: ");
								moveto(8*8,0);
								sal = mpscanf("Sala:  ");
								while (sal<1 || sal>4){
									msgbox("Error","Slo hay cuatro salas");
									outtextxy(0,0,"Sala: ");
									moveto(8*8,0);
									sal = mpscanf("Sala:  ");
								}
								outtextxy(0,20,"Micro: ");
								moveto(8*8,20);
								micro = mpscanf("Micro: ");
								outtextxy(0,40,"Hora: ");
								moveto(8*8,40);
								hor = mpscanf("Hora: ");
								cancelar_turno(sal,hor,micro,planilla);
								menu_principal();
								setviewport(8,80,getmaxx(),getmaxy(),1);
								break;
							 }
		case 4: {   cleardevice();
								setviewport(0,0,getmaxx(),getmaxy(),1);
								setfillstyle(4,2);
								bar(8,8,630,50);
								rectangle(8,8,630,50);
								setusercharsize(8,9,8,9);
								settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
								outtextxy((640-(strlen("AGREGAR CURSO")*textwidth("T")))/2,10,"AGREGAR CURSO");
								setusercharsize(1,2,1,2);
								setviewport(8,80,getmaxx(),getmaxy(),1);
								outtextxy(0,0,"Sala: ");
								moveto(8*8,0);
								sal=mpscanf("Sala: ");
								while (sal<1 || sal>4){
									msgbox("Error","Slo hay cuatro salas");
									outtextxy(0,0,"Sala: ");
									moveto(8*8,0);
									sal = mpscanf("Sala:  ");
								}
								outtextxy(0,30,"Codigo del Curso: ");
								moveto(19*8,30);
								cod=mpscanf("Codigo del Curso: ");
								agregar_curso(sal,cod,planilla);
								clearviewport();
								menu_principal();
								setviewport(8,80,getmaxx(),getmaxy(),1);
								break;
							 }
		case 5: {		cleardevice();
								setviewport(0,0,getmaxx(),getmaxy(),1);
								setfillstyle(4,2);
								bar(8,8,630,50);
								rectangle(8,8,630,50);
								setusercharsize(8,9,8,9);
								settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
								outtextxy((640-(strlen("AGREGAR ALUMNO")*textwidth("T")))/2,10,"AGREGAR ALUMNO");
								setusercharsize(1,2,1,2);
								setviewport(8,80,getmaxx(),getmaxy(),1);
								outtextxy(0,0,"Sala: ");
								moveto(8*8,0);
								sal=mpscanf("Sala: ");
								while (sal<1 || sal>4){
									msgbox("Error","Slo hay cuatro salas");
									outtextxy(0,0,"Sala: ");
									moveto(8*8,0);
									sal = mpscanf("Sala:  ");
								}
								outtextxy(0,30,"Codigo del Curso: ");
								moveto(19*8,30);
								cod=mpscanf("Codigo del Curso: ");
								outtextxy(0,60,"Carnet: ");
								moveto(10*8,60);
								carn=mpscanf("Carnet: ");
								agregar_estudiante(sal,cod,carn,planilla);
								clearviewport();
								menu_principal();
								setviewport(8,80,getmaxx(),getmaxy(),1);
								break;
							 }

}
	if (sw != TRUE) base_de_datos(planilla);
	clearviewport();
}
//****************************************************************************
//														 MENU-ESTRUCTURA
//****************************************************************************
void estructura()
{
	int Done,linea,opcion,c,i,sw;
	char op[2][20] = {{"Mostrar estructura"},{"Explicacin"}};
	char op2[9][80] = {{"  	Una matriz tridimensional:  Horas, Micros y Salas."},
										 {" "},
										 {"    Cuatro apuntadores a estructuras tipo Curso, cada una de las cuales "},
										 {"     contienen un campo para almacenar el cdigo del curso y un puntero "},
										 {"     a una estructura tipo Estud."},
										 {" "},
										 {"    Las estructuras tipo Estud representan cada una a un estudiante, "},
										 {"     contienen un campo para el nmero del carnet y un apuntador al "},
										 {"     siguiente estudiante."}
										};
	clearviewport();
	setusercharsize(1,2,1,2);
	rectangle(150,0,330,80);
	setfillstyle(4,2);
	bar(151,20,329,42);
	rectangle(151,20,329,42);
	outtextxy(170,20,op[0]);
	outtextxy(170,40,op[1]);

	opcion = 1;
	linea = 20;

	sw = FALSE;
	Done=FALSE;
	while (Done==FALSE) {
		c=getch();
		switch (c) {
		case 0: {
				c=getch();
				switch (c){
case 80: {                        					// abajo
					setfillstyle(4,0);
					bar(151,linea,329,linea+22);
					outtextxy(170,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 2){
														 linea = 20;
														 opcion = 1;
														 }
					else {
								linea += 20;
								opcion++;
								}
					bar(151,linea,329,linea+22);
					rectangle(151,linea,329,linea+22);
					outtextxy(170,linea,op[opcion-1]);
					break;
					}
case 72: {                        					// arriba
					setfillstyle(4,0);
					bar(151,linea,329,linea+22);
					outtextxy(170,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 1){
														 linea = 40;
														 opcion = 2;
														 }
					else {
								linea -= 20;
								opcion--;
								}
					bar(151,linea,329,linea+22);
					rectangle(151,linea,329,linea+22);
					outtextxy(170,linea,op[opcion-1]);
					break;
					}
				} 				// switch interno.
				break;
			} 					// case externo.
			case 13:  { Done=TRUE;	break; }										      //{ Enter }
			case 27:  {	Done=TRUE;	sw = TRUE;  opcion = 0;	break; }    //{	Esc	}
		}  // switch externo.
	}    // while.

	switch (opcion){
	case 1: {	clearviewport();
						rectangle(130,40,520,190);
						setusercharsize(1,2,1,2);
						settextstyle(SANS_SERIF_FONT, HORIZ_DIR, 0);
						outtextxy(90,10,"D-4   0                                         Max-1");
						outtextxy(110,50,"0");		outtextxy(100,170,"11");
						//	verticales.
						line(160,40,160,190);	line(190,40,190,190);	line(220,40,220,190);
						line(250,40,250,190); line(280,40,280,190);	line(310,40,310,190);
						line(340,40,340,190); line(370,40,370,190);	line(400,40,400,190);
						line(430,40,430,190); line(460,40,460,190); line(490,40,490,190);

						line(130,70,520,70);	line(130,100,520,100); line(130,130,520,130);
						line(130,160,520,160);	//	horizontales.

						rectangle(80,230,120,380); line(80,260,120,260);	line(80,290,120,290);
						line(80,320,120,320);	 line(80,350,120,350);  line(50,240,70,240);
						line(66,236,70,240);	 line(65,236,69,240);
						line(66,244,70,240);	 line(65,244,69,240);

						outtextxy(70,260,"1");	outtextxy(70,290,"2");
						outtextxy(70,320,"3");  outtextxy(70,350,"4");

						rectangle(160,260,265,290);	outtextxy(170,265,"Curso");
						line(225,260,225,290);  line(245,260,245,290);

						line(130,270,150,270);
						line(145,266,150,270);	line(146,266,150,270);
						line(145,274,150,270);	line(146,274,150,270);

						rectangle(300,260,405,290);	outtextxy(310,265,"Curso");
						line(365,260,365,290);  line(385,260,385,290);

						line(275,270,295,270);
						line(290,266,295,270);	line(291,266,295,270);
						line(290,274,295,270);	line(291,274,295,270);

						rectangle(160,320,265,350);	outtextxy(170,325,"Carnet");
						line(225,320,225,350);  line(245,320,245,350);

						line(235,300,235,315);
						line(230,310,235,315);	line(231,310,235,315);
						line(240,310,235,315);	line(239,310,235,315);

						rectangle(500,250,560,370); line(500,280,560,280);
						line(500,310,560,310);  line(500,340,560,340);

						outtextxy(505,255,"Carnet");  outtextxy(505,285,"Carnet");
						outtextxy(505,315,"Carnet");  outtextxy(505,345,"Carnet");

						outtextxy(565,255,"0");				outtextxy(565,285,"1");
						outtextxy(565,315,"2");				outtextxy(565,345,"3");

						line(450,195,450,264);  line(450,264,480,264);

						line(475,259,480,264);	line(474,259,480,264);
						line(475,269,480,264);	line(474,269,480,264);
						getch();
						break;
						}
	case 2: { linea = 30;
						clearviewport();
						for (i=0;i<9; i++){
							outtextxy(10,linea,op2[i]);
							linea += 25;
						}
						getch();
						break;
					}
	}
	if (sw != TRUE) estructura();
	clearviewport();
}
//****************************************************************************
//																MENU-AYUDA
//****************************************************************************
void ayuda()
{
	int sal,cod,carn,hor,i,opcion,linea,Done,c,idc,sw;
	char ch[3];
	char est[9][80] = {{"  	Una matriz tridimensional:  Horas, Micros y Salas."},
										 {" "},
										 {"    Cuatro apuntadores a estructuras tipo Curso, cada una de las cuales "},
										 {"     contienen un campo para almacenar el cdigo del curso y un puntero "},
										 {"     a una estructura tipo Estud."},
										 {" "},
										 {"    Las estructuras tipo Estud representan cada una a un estudiante, "},
										 {"     contienen un campo para el nmero del carnet y un apuntador al "},
										 {"     siguiente estudiante."}
										};
	char ope[7][80] = {{" Las operaciones bsicas del sistema son:"},
										 {" "},
										 {"    Reservar un turno para un estudiante."},
										 {"    Consultar un turno a una hora dada."},
										 {"    Cancelar la reserva del turno de un estudiante."},
										 {"    Agregar un curso a la base de datos."},
										 {"    Agregar una sala a la base de datos."},
										};
	char apt[10][80] = {{" Para apartar un turno:"},
										 {" "},
										 {"    El estudiante debe estar registrado en un curso vlido."},
										 {"    El curso debe existir y estar asignado a la sala indicada."},
										 {"    El estudiante debe estar registrado en el curso indicado."},
										 {"    La hora debe estar dentro del rango definido entre las siete am"},
										 {"     y las siete pm. "},
										 {"    Si al solicitar el turno no se puede ver un cuadro indicando el "},
										 {"     nmero de micro, la sala y la hora, la operacin no fue realizada"},
										 {"     con xito, es decir, el turno no fue apartado."},
										};
	char acu[7][80] = {{" Para agregar un curso:"},
										 {" "},
										 {"    Debe proporcionarse un codigo para el curso y una sala para el "},
										 {"     mismo,es decir la sala a la que ser asignado el curso recin"},
										 {"     creado."},
										};
	char op[5][50]={"Estructura",
									"Operaciones bsicas",
									"Apartar turno",
									"Agregar curso",
									"Agregar estudiante"};
	clearviewport();
	for (i=1;i<5; i++){
			outtextxy(310,(i*20)+20,op[i]);
	}
	rectangle(293,0,475,144);
	setfillstyle(4,2);
	bar(294,20,474,42);
	rectangle(294,20,474,42);
	setusercharsize(1,2,1,2);
	outtextxy(310,20,op[0]);

	opcion = 1;
	linea = 20;

	Done=FALSE;
	while (Done==FALSE) {
		c=getch();
		switch (c) {
			case 0: {
				c=getch();
				switch (c){
case 80: {                        					// abajo
					setfillstyle(4,0);
					bar(294,linea,474,linea+22);
					outtextxy(310,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 5){
														 linea = 20;
														 opcion = 1;
														 }
					else {
								linea += 20;
								opcion++;
								}
					bar(294,linea,474,linea+22);
					rectangle(294,linea,474,linea+22);
					outtextxy(310,linea,op[opcion-1]);
					break;
					}
case 72: {                        					// arriba
					setfillstyle(4,0);
					bar(294,linea,474,linea+22);
					outtextxy(310,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 1){
														 linea = 100;
														 opcion = 5;
														 }
					else {
								linea -= 20;
								opcion--;
								}
					bar(294,linea,474,linea+22);
					rectangle(294,linea,474,linea+22);
					outtextxy(310,linea,op[opcion-1]);
					break;
					}
				} 				// switch interno.
				break;
			} 					// case externo.
			case 13:  { Done=TRUE;	break; }		    								  //{ Enter }
			case 27:  {	Done=TRUE;	sw = TRUE;	opcion = 0;	break; }  //{	Esc	}
		}  // switch externo.
	}    // while.
	switch (opcion){
	case 1: { linea = 30;
						clearviewport();
						for (i=0;i<9; i++){
							outtextxy(10,linea,est[i]);
							linea += 25;
						}
						getch();
						break;
					}
	case 2: { linea = 30;
						clearviewport();
						for (i=0;i<7; i++){
							outtextxy(10,linea,ope[i]);
							linea += 25;
						}
						getch();
						break;
					}
	case 3: { linea = 30;
						clearviewport();
						for (i=0;i<10; i++){
							outtextxy(10,linea,apt[i]);
							linea += 25;
						}
						getch();
						break;
					}
	case 4: { linea = 30;
						clearviewport();
						for (i=0;i<7; i++){
							outtextxy(10,linea,acu[i]);
							linea += 25;
						}
						getch();
						break;
					}
	}
	if (sw != TRUE) ayuda();
	clearviewport();
}
//****************************************************************************
//															MENU-CREDITOS
//****************************************************************************
void creditos()
{
	int i,Done,sw,opcion,linea,c;
	char op[2][20] = {	{"Animacin"},	{"Integrantes"}	};

	clearviewport();

	rectangle(433,0,605,80);
	setfillstyle(4,2);
	bar(434,20,604,42);
	rectangle(434,20,604,42);
	setusercharsize(1,2,1,2);
	outtextxy(455,20,op[0]);
	outtextxy(455,40,op[1]);

	opcion = 1;
	linea = 20;

	Done=FALSE;
	while (Done==FALSE) {
		c=getch();
		switch (c) {
			case 0: {
				c=getch();
				switch (c){
case 80: {                        					// abajo
					setfillstyle(4,0);
					bar(434,linea,604,linea+22);
					outtextxy(455,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 2){
														 linea = 20;
														 opcion = 1;
														 }
					else {
								linea += 20;
								opcion++;
								}
					bar(434,linea,604,linea+22);
					rectangle(434,linea,604,linea+22);
					outtextxy(455,linea,op[opcion-1]);
					break;
					}
case 72: {                        					// arriba
					setfillstyle(4,0);
					bar(434,linea,604,linea+22);
					outtextxy(455,linea,op[opcion-1]);
					setfillstyle(4,2);
					if (opcion == 1){
														 linea = 40;
														 opcion = 2;
														 }
					else {
								linea -= 20;
								opcion--;
								}
					bar(434,linea,604,linea+22);
					rectangle(434,linea,604,linea+22);
					outtextxy(455,linea,op[opcion-1]);
					break;
					}
				} 				// switch interno.
				break;
			} 					// case externo.
			case 13:  { Done=TRUE;	break; }		    								  //{ Enter }
			case 27:  {	Done=TRUE;	sw = TRUE;	opcion = 0;	break; }  //{	Esc	}
		}  // switch externo.
	}    // while.

switch (opcion){
case 1: {
	settextstyle(GOTHIC_FONT,HORIZ_DIR,0);
	for (i=15; i>=1; i--)
	{
		clearviewport();
		setusercharsize(i*2,2,i*2,2);
		outtextxy(i*20,150,"Juan Gabriel Ramos   Cod. 7400-043");
		outtextxy(i*20,100,"Edgar Andredy Perez  Cod. 7400-089");
		delay(20);
	 }
	 getch();
	 settextstyle(SANS_SERIF_FONT,HORIZ_DIR,0);
	 break;
	}
case 2: {
	clearviewport();
	setusercharsize(1,2,1,2);
	settextstyle(SANS_SERIF_FONT,HORIZ_DIR,0);
	outtextxy((640-(19*10))/2+6,60,"Edgar Andredy Perez");
	outtextxy((640-(13*10))/2-10,80,"Cod. 7400-089");
	outtextxy((640-(18*10))/2,100,"Juan Gabriel Ramos");
	outtextxy((640-(13*10))/2-10,120,"Cod. 7400-043");
	outtextxy((640-(23*10))/2+10,140,"Universidad de Pamplona");
	outtextxy((640-(45*10))/2+40,160,"Facultad de Ciencias Naturales y Tecnolgicas");
	outtextxy((640-(4*10))/2-10,180,"2001");
	getch();
	break;
	}
}
	if (sw != TRUE) creditos();
	clearviewport();
}
//****************************************************************************
//****************************************************************************
//															BLOQUE-PRINCIPAL
//****************************************************************************
//****************************************************************************
void main(void)
{
	int i,Done,ch;
	char string[1];
	Salas planilla;
	int gdriver = DETECT, gmode;
	initgraph(&gdriver, &gmode, "");
	ver_errores();
	planilla = init_salas(planilla);
	menu_principal();
	setviewport(8,80,getmaxx(),getmaxy(),1);

	Done=FALSE;
	while (Done==FALSE) {
		ch=getch();
		switch (ch) {
			case 0: {
				ch=getch();
				switch (ch){
					case 48: { base_de_datos(planilla); break; }			 // { Alt-B }
					case 18: { estructura();		break; }			 // { Alt-E }
					case 30: { ayuda();					break; }			 // { Alt-A}
					case 46: { creditos();			break; }			 // { Alt-C }
					case 31: { Done = TRUE;			break; }			 // { Alt-S }
				} 				// switch interno.
				break;
			} 					// case externo.
			case 27:  { Done=TRUE;	break; }										//{ Esc }
			case 97:  { ayuda();  break; }											//{ A }
			case 98:  { base_de_datos(planilla);  break; }							//{ B }
			case 101: { estructura();  break; }									//{ E }
			case 99:  { creditos();	break; }                    //{ C }
			case 115: { Done=TRUE;  break; }										//{ S }
		}  // switch externo.
	}    // while.
	closegraph();
}
//****************************************************************************
//****************************************************************************