//---------------------------------------------------------------------------
#ifndef ccitaH
#define ccitaH
//---------------------------------------------------------------------------
#include "cpersona.h"

//---------------------------------------------------------------------------
// Clase que representa una fecha
class CFecha {
public:
    // Constructor
    CFecha(int dia, int mes, int anno);
    // Constructor vaco
    CFecha();
    // Mtodos de acceso
    int GetDia() const;
    int GetMes() const;
    int GetAnno() const;
private:
    int dia;
    int mes;
    int anno;
};

//---------------------------------------------------------------------------
// Clase que representa una hora
class CHora {
public:
    // Constructor
    CHora (int horas, int minutos);
    // Constructor vaco
    CHora();
    // Mtodos de acceso
    int GetHoras() const;
    int GetMinutos() const;
private:
    int horas;
    int minutos;
};

//---------------------------------------------------------------------------
// Clase que representa una cita
class CCita {
public:
    // Constructor: crea una cita con los datos necesarios
    CCita(CFecha &fecha, CHora &hinicio, CHora &hfin, CPersona const *persona,
          char * lugar);
    // Destructor: libera memoria
    ~CCita();
    // Devuelve la fecha
    CFecha const & GetFecha() const;
    // Devuelve la hora de inicio
    CHora const & GetHoraInicio() const;
    // Devuelve un puntero a la persona asociada
    CPersona const * GetPersona() const ;
    // Dice si la fecha y hora de inicio coinciden con los argumentos
		void IgualFechaHora(CFecha const & fecha, CHora const & hinicio) const;
    // Compara con otra cita, devolviendo -1, 0  1 segn corresponda
    int CompararCita(CCita const & cita) const;
    // Dice si la fecha coincide con el argumento
		void IgualFecha(CFecha const & fecha) const;
    // Escribe los datos de una cita
    void EscribirDatos() const;
private:
    CFecha fecha;
    CHora hinicio;
    CHora hfin;
    CPersona const * persona;
    char * lugar;
};
//---------------------------------------------------------------------------
#endif
