//---------------------------------------------------------------------------
#ifndef clistacH
#define clistacH

//---------------------------------------------------------------------------
#include "retorno.h"
#include "ccita.h"
//---------------------------------------------------------------------------
class CNodoListaCitas {
public:
    // Constructor: a partir de una cita
    CNodoListaCitas(CCita *c);
    // Destructor: libera memoria de la cita
    ~CNodoListaCitas();
    // Obtiene el nodo siguiente
    CNodoListaCitas * GetSig() const;
    // Modifica el nodo siguiente
    void SetSig(CNodoListaCitas *nodo);
    // Obtiene la cita asociada al nodo
    CCita const * GetCita() const;
private:
    // Dato almacenado: una cita
    CCita *cita;
    // Siguiente nodo en la lista
    CNodoListaCitas * sig;
};


//---------------------------------------------------------------------------
class CListaCitas {
public:
   // Constructor vaco
   CListaCitas();
   // Destructor: libera toda la memoria
   ~CListaCitas();
   // Aade un elemento a la lista de citas. La cita debe ser correcta (es
   // decir, debe estar asociada a una persona de la agenda).
   TRes AgregarCita(CCita * cita);
   // Consultar las citas de un da
   TRes ConsultarCita(CFecha const & fecha) const;
   // Eliminar una cita
   TRes EliminarCita(CFecha const & fecha, CHora const & hinicio);
   // Eliminar las citas asociadas a una persona
   TRes EliminarCitasPersona (char const * nombre);
private:
   // Comprueba si existe una cita, dados la fecha y la hora de comienzo
	 void ExisteCita(CCita const * cita) const;
   // Inserta un nodo de forma ordenada
   void InsertarOrden(CNodoListaCitas * nodo);
   // La lista de nodos
   CNodoListaCitas *lista;
};
#endif
