//---------------------------------------------------------------------------
#ifndef clistapH
#define clistapH

#include "retorno.h"
#include "cpersona.h"

//---------------------------------------------------------------------------
// Clase que representa un nodo de la lista de personas
class CNodoListaPersonas {
public:
    // Constructor: a partir de una persona
    CNodoListaPersonas(CPersona *p);
    // Destructor: libera memoria de la persona
    ~CNodoListaPersonas();
    // Obtiene la persona almacenada
    CPersona const * GetPersona() const;
    // Obtiene el nodo siguiente
    CNodoListaPersonas * GetSig() const;
    // Modifica el nodo siguiente
    void SetSig(CNodoListaPersonas * nodo);
private:
    // Dato almacenado: una persona (de cualquier tipo)
    CPersona *per;
    // Siguiente nodo en la lista
    CNodoListaPersonas * sig;
};

//---------------------------------------------------------------------------
// Clase que representa una lista enlazada de personas
class CListaPersonas {
public:
   // Constructor vaco
   CListaPersonas();
   // Destructor: libera toda la memoria
   ~CListaPersonas();
   // Mtodo que dice si la lista est vaca
	 void Vacia() const;
	 // Aade un elemento a la lista.
	 TRes AgregarPersona(CPersona * persona);
	 // Consultar los datos de una persona
	 TRes ConsultarPersona(char const * nombre) const;
	 // Eliminar una persona (y las citas en las que aparece)
	 TRes EliminarPersona(char const * nombre);
	 // Busca una persona en la lista (por nombre)
	 CPersona const * BuscarPersona(char const * nombre) const;
private:
	 // Inserta un nodo de forma ordenada
	 void InsertarOrden(CNodoListaPersonas *nodo);
	 // La lista de nodos
	 CNodoListaPersonas *lista;
};
//---------------------------------------------------------------------------
#endif
