//---------------------------------------------------------------------------
#ifndef cpersonaH
#define cpersonaH
//---------------------------------------------------------------------------
// Clase base: representa cualquier tipo de persona
class CPersona {
public:
    // Constructor: crea una persona a partir de los datos necesarios
    CPersona(char * nombre, long telefono);
    // Destructor: libera memoria
    virtual ~CPersona();
    // Devuelve el nombre
    char const * GetNombre() const;
    // Dice si tiene el mismo nombre que el parmetro
		void IgualNombre(char const * nombre) const;
		// Compara el nombre con el parmetro. Resultado igual que strcmp.
		int CompararNombre(char const * nombre) const ;
		// Devuelve el nmero de telfono
		long GetTelefono() const;
		// Escribir datos en pantalla (mtodo virtual puro)
		virtual void EscribirDatos() const =0;
private:
		// Datos de la persona
		char *nombre;
		long telefono;  // Nmero de telfono
};

//---------------------------------------------------------------------------
// Clase que representa una persona conocida
class CPersonaConocida: public CPersona {
public:
		// Constructor: crea una persona a partir de los datos necesarios
		CPersonaConocida(char * nombre, long telefono, char * email);
		// Destructor: libera memoria
		~CPersonaConocida();
		// Escribir datos en pantalla
		void EscribirDatos() const;
private:
		// Datos de la persona amiga: se aade el email
    char *email;    // Direccin de correo electrnico
};

//---------------------------------------------------------------------------
// Clase que representa una persona de empresa
class CPersonaEmpresa: public CPersona {
public:
    // Constructor: crea una persona a partir de los datos necesarios
    CPersonaEmpresa(char * nombre, long telefono, char * nempresa);
    // Destructor: libera memoria
    ~CPersonaEmpresa();
    // Escribir datos en pantalla
    void EscribirDatos() const;
private:
    // Datos de la persona de empresa: se aade el nombre de la empresa
    char *nempresa;    // Direccin de correo electrnico
};
//---------------------------------------------------------------------------
#endif
