#include"dos.h"
#include"ctype.h"
#include"conio.h"
#include"math.h"
#include"stdio.h"
#include"graphics.h"

class Piano
{ public:
	void Teclado();
	void Bolita( int accion, int octava, int nota);
	void Sonido( int octava, int nota);
	void TocarNota(char tecla1,char tecla2);
};

void Piano::Teclado()
{
	setfillstyle(BLUE,BLUE);
	bar(5,70,635,170);
	for(int i=1; i<21; i++)
	{
		int x = i*630/21;
		line(5+x,70,5+x,170);
		setfillstyle(BLUE,BLACK);
		if( i%7!=0 && i%7!=3 )
			bar((x-10)+5,70,(x+10)+5,130);
		if( i%7 == 1 )
			fillellipse(x-(630/21)/2+5,160,3,3);
	}
	settextstyle(7,HORIZ_DIR,2);
	outtextxy(230,20,"Seudo-Piano");
	setfillstyle(SOLID_FILL,WHITE); //16=BLANCO
	outtextxy(10,190,"Notas tocadas");
	moveto(10,230);
	settextstyle(SMALL_FONT, HORIZ_DIR, 7);
	setcolor(3);
	outtextxy(0,450,"Esta es una produccin ms de:");
	setcolor(12);
	settextstyle(GOTHIC_FONT,HORIZ_DIR,0);
	outtextxy(380,440,"Raptor's");
	settextstyle(11, HORIZ_DIR, 2);
}

void Piano::Bolita( int accion, int octava, int nota)
{
 int k=630/21,pos,x,y,color;
 int sostenido=1;
 switch(nota)
 {
	case 2:	 pos=1; break;
	case 4:	 pos=2; break;
	case 7:	 pos=4; break;
	case 9:	 pos=5; break;
	case 11: pos=6; break;
	default: sostenido=0;
		switch(nota)
		{
			case 1:pos=1;break;
			case 3:pos=2;break;
			case 5:pos=3;break;
			case 6:pos=4;break;
			case 8:pos=5;break;
			case 10:pos=6;break;
			case 12:pos=7;break;
		}
 }
 if(sostenido)
 {
	 x=5+(7*(octava-3)+pos)*k;
	 y=100;
 }
 else
 {
	 x=5+(7*(octava-3)+pos)*k-k/2;
	 y=150;
 }
 if(accion)	color=4;
 else if(sostenido)	color=0;
 else color=1;
 setcolor(color);
 setfillstyle(1,color);
 fillellipse(x,y,5,5);
}

void Piano::Sonido( int octava, int nota)
{
 int i,f=0;
 double frecuencia=123.75;
 Bolita(1,octava,nota);

 switch(nota)	       // Frecuencias de las octavas
 {
	 case 12: f+=120;  //SI
	 case 11: f+=100;  //LA#
	 case 10: f+=100;  //LA
	 case 9:  f+=90;   //SOL#
	 case 8:  f+=90;   //SOL
	 case 7:  f+=90;   //FA#
	 case 6:  f+=70;   //FA
	 case 5:  f+=70;   //MI
	 case 4:  f+=80;   //RE#
	 case 3:  f+=60;   //RE
	 case 2:  f+=60;   //DO#
	 case 1:  f+=60;   //DO OCTAVA4
 }

 for( i=0; i<octava-1; i++)
	frecuencia+=990*pow(2,i-3);

 frecuencia+=f*pow(2,octava-4); // clculo de la frecuencia
 sound(frecuencia);
 delay(200);
 nosound();
 Bolita(0,octava,nota);         //borra el circulo rojo
 if(getx() >= getmaxx()-50) moveto(10, gety()+15);
 setcolor(YELLOW);
 char *Nota;
 switch(nota)
 {
	case 12:  outtext("SI ");	  break; //SI
	case 11:	outtext("LA# ");	break; //LA#
	case 10:	outtext("LA ");	  break; //LA
	case 9:		outtext("SOL# "); break; //SOL#
	case 8:		outtext("SOL ");	break; //SOL
	case 7:		outtext("FA# ");	break; //FA#
	case 6:		outtext("FA ");   break; //FA
	case 5:		outtext("MI ");	  break; //MI
	case 4:		outtext("RE# ");	break; //RE#
	case 3:		outtext("RE ");   break; //RE
	case 2:		outtext("DO# ");  break; //DO#
	case 1:		outtext("DO ");   break; //DO OCTAVA4
 }
}

void Piano::TocarNota(char tecla1,char tecla2)
{
 switch(tecla1)
 {
	 case '`': Sonido(3,7);break;//FA#
	 case  9 : Sonido(3,8);break;//SOL
	 case '1': Sonido(3,9);break;//SOL#
	 case 'Q': Sonido(3,10);break;//LA   - frecuencia(Hz)=880
	 case '2': Sonido(3,11);break;//LA#
	 case 'W': Sonido(3,12);break; //SI
	 case 'E': Sonido(4,1);break;  //DO  OCTAVA4
	 case '4': Sonido(4,2);break;  //DO#
	 case 'R': Sonido(4,3);break;  //RE
	 case '5': Sonido(4,4);break;  //RE#
	 case 'T': Sonido(4,5);break;  //MI
	 case 'Y': Sonido(4,6);break;  //FA
	 case '7': Sonido(4,7);break;  //FA#
	 case 'U': Sonido(4,8);break;  //SOL
	 case '8': Sonido(4,9);break;  //SOL#
	 case 'I': Sonido(4,10);break; //LA
	 case '9': Sonido(4,11);break; //LA#
	 case 'O': Sonido(4,12);break; //SI
	 case 'P': Sonido(5,1);break;  //DO  OCTAVA5
	 case '-': Sonido(5,2);break;  //DO#
	 case '[': Sonido(5,3);break;  //RE
	 case '=': Sonido(5,4);break;  //RE#
	 case ']': Sonido(5,5);break;  //MI
	 case 13:  Sonido(5,6);break;  //FA
 }

 if(!tecla1)
 {
	 switch(tecla2)
	 {
		 case 82: Sonido(5,7); break;  //FA#
		 case 83: Sonido(5,8); break;  //SOL
		 case 71: Sonido(5,9); break;  //SOL#
		 case 79: Sonido(5,10); break; //LA
		 case 73: Sonido(5,11); break; //LA#
		 case 81: Sonido(5,12); break; //SI
	}
 }
}


void main()
{
	int grdriver=DETECT,grmode;
	initgraph(&grdriver,&grmode,"..//bgi");
	Piano P;

	char tecla1=0,tecla2=0;

	P.Teclado();

	do{
		tecla1 = toupper(getch());
		if(!tecla1) tecla2 = toupper(getch());
		P.TocarNota(tecla1,tecla2);
	}while(tecla1!=27);

	closegraph();
}

